# DeFi Lending Platform Evaluation

[toc]

## Evaluated Platforms

Aave (currently in V2), Compound, TrueFi (currently in V4), Cream Finance, Alchemix, dydx.

## Data Preparation

### Smart Contract

1. Launched time
    The launched time is the time when a certain protocol started running in mainnet.
    - TrueFi: https://docs.truefi.io/faq/pool#lending-pools-smart-contracts
    - dydx: https://github.com/dydxprotocol/solo
2. Number of vulneratbilities
3. Bug Bounty
    - Aave: https://aave.com/bug-bounty/
    - MakerDAO: https://security.makerdao.com/
    - Compound: https://compound.finance/docs/security
    - Liquity: https://docs.liquity.org/documentation/bug-bounty
    - Synthetix: https://blog.synthetix.io/synthetix-bug-bounties/
    - TrueFi: https://github.com/trusttoken/bug-bounty
4. Audit status
    - Aave: https://docs.aave.com/developers/security-and-audits
    - MarkerDAO: https://security.makerdao.com/audit-reports
    - Compound: https://compound.finance/docs/security
    - Liquity: https://github.com/trailofbits/publications/blob/master/reviews/Liquity.pdf
    - Synthetix: https://github.com/sigp/public-audits
    - TrueFi: https://blog.trusttoken.com/mitigating-risk-truefis-loan-default-process-454359a8c4b
5. Recent update

### Finance

1. Token values
2. ESG factor
    - Aave: https://governance.aave.com/c/governance/4
    - Compound: https://www.comp.xyz/
    - TrueFi: https://forum.truefi.io/
    - Cream Finance: https://forum.cream.finance/
    - Alchemix: https://forum.alchemix.fi/public/
    - dydx: https://forums.dydx.community/
3. Lending amount
4. Borrowing amount

### Intermediary

1. Admin key
2. Blockchain oracle

## Future Works

- [ ] Automatically check the audit status.

## References for Modelling

1. https://arxiv.org/pdf/2106.06389.pdf
2. https://github.com/aave/protocol-v2/blob/master/aave-v2-whitepaper.pdf
3. https://www.tandfonline.com/doi/abs/10.2469/faj.v74.n3.2
4. https://blogs.lse.ac.uk/businessreview/2021/02/05/can-investors-embrace-both-cryptocurrencies-and-esg/
5. https://dyor-crypto.fandom.com/wiki/Alchemix_(ALCX)#Governance
6. [Predicting Issue Types on GitHub](https://arxiv.org/pdf/2107.09936.pdf)
7. [DeepJIT: An End-To-End Deep Learning Framework for Just-In-Time Defect Prediction](https://posl.ait.kyushu-u.ac.jp/~kamei/publications/Thong_MSR2019.pdf)
8. Are Fix-Inducing Changes a Moving Target? A Longitudinal Case Study of Just-In-Time Defect Prediction
9. [JITLine: A Simpler, Better, Faster, Finer-grained Just-In-Time Defect Prediction](https://arxiv.org/pdf/2103.07068.pdf)
10. [Just-In-Time Defect Identification and Localization: A Two-Phase Framework](https://pdfs.semanticscholar.org/34bd/efd6a79195aed8f3cecbfa2fe82ae4ccef7a.pdf?_ga=2.251218949.224539333.1635584133-1176253247.1635217848)
11. [Revisiting Unsupervised Learning for Defect Prediction](https://arxiv.org/pdf/1703.00132.pdf)